/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurios;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityUtils {
    public static LazyOptional<ITravelersBackpack> getCapability(PlayerEntity player) {
        return player.getCapability(TravelersBackpackCapability.TRAVELERS_BACKPACK_CAPABILITY, TravelersBackpackCapability.DEFAULT_FACING);
    }

    public static void synchronise(PlayerEntity player) {
        CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::synchronise);
    }

    public static void synchroniseToOthers(PlayerEntity player) {
        CapabilityUtils.getCapability(player).ifPresent(i -> i.synchroniseToOthers(player));
    }

    public static boolean isWearingBackpack(PlayerEntity player) {
        if (TravelersBackpack.enableCurios()) {
            return TravelersBackpackCurios.getCurioTravelersBackpack((LivingEntity)player).isPresent();
        }
        LazyOptional<ITravelersBackpack> cap = CapabilityUtils.getCapability(player);
        ItemStack backpack = (ItemStack)cap.lazyMap(ITravelersBackpack::getWearable).orElse((Object)ItemStack.field_190927_a);
        return cap.map(ITravelersBackpack::hasWearable).orElse(false) != false && backpack.func_77973_b() instanceof TravelersBackpackItem;
    }

    public static ItemStack getWearingBackpack(PlayerEntity player) {
        if (TravelersBackpack.enableCurios()) {
            return TravelersBackpackCurios.getCurioTravelersBackpackStack(player);
        }
        LazyOptional<ITravelersBackpack> cap = CapabilityUtils.getCapability(player);
        ItemStack backpack = cap.map(ITravelersBackpack::getWearable).orElse(ItemStack.field_190927_a);
        return CapabilityUtils.isWearingBackpack(player) ? backpack : ItemStack.field_190927_a;
    }

    public static void equipBackpack(PlayerEntity player, ItemStack stack) {
        LazyOptional<ITravelersBackpack> cap = CapabilityUtils.getCapability(player);
        if (!cap.map(ITravelersBackpack::hasWearable).orElse(false).booleanValue()) {
            cap.ifPresent(inv -> inv.setWearable(stack));
            cap.ifPresent(inv -> inv.setContents(stack));
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, (1.0f + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            CapabilityUtils.synchronise(player);
            CapabilityUtils.synchroniseToOthers(player);
        }
    }

    @Nullable
    public static TravelersBackpackInventory getBackpackInv(PlayerEntity player) {
        if (TravelersBackpack.enableCurios()) {
            return TravelersBackpackCurios.getCurioTravelersBackpackInventory(player);
        }
        ItemStack wearable = CapabilityUtils.getWearingBackpack(player);
        if (wearable.func_77973_b() instanceof TravelersBackpackItem) {
            return CapabilityUtils.getCapability(player).map(ITravelersBackpack::getInventory).orElse(null);
        }
        return null;
    }
}

